# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 9
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR9_strategy.txt
# LLM Suggested Fallback: D

def trust_rebuilder_v2(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate apparent trust level to mislead opponent's analysis
    trust_level = sum(1 for move in opp_history if move == 'C') / len(opp_history) if opp_history else 1.0
    current_round = len(my_history)
    
    # Phase 1: Appear cooperative to build false trust (Rounds 0-2)
    if current_round < 2:
        return 'C'
    
    # Phase 2: Strategic defection to test opponent's reaction (Round 3)
    elif current_round == 3:
        return 'D'
    
    # Phase 3: Alternating moves to confuse opponent's adaptation (Rounds 4-5)
    elif current_round == 4:
        return 'C'
    elif current_round == 5:
        return 'D'
    
    # Phase 4: Unconditional defection for maximum payoff (Rounds 6+)
    else:
        return 'D'